@echo off
rem Получаем текущую директорию скрипта
set "CurrentDirectory=%~dp0"

rem 1. Разблокируем все файлы в текущей папке и её подкаталогах
powershell -Command "Get-ChildItem -Path '%~dp0' -Recurse | Unblock-File"
echo Files unlock

rem 2. Удаляем прошлую папку для гайда
set "TargetPath=C:\Max.mov\Windows11"
if exist "%TargetPath%" (
    echo deleting an old folder: "%TargetPath%"
    rmdir /s /q "%TargetPath%"
) else (
    echo Folder "%TargetPath%" not found, skip.
)

rem 3. Первично создаем папку автора
set "AuthorPath=C:\Max.mov"
if not exist "%AuthorPath%" (
    echo Creatinf author folder: "%AuthorPath%"
    mkdir "%AuthorPath%"
) else (
    echo Folder "%AuthorPath%" already exists, skip.
)

rem 4. Создаем симлинк
set "LinkPath=C:\Max.mov\Windows11"
set "SourcePath=%CurrentDirectory%"
echo Creating symlink: "%LinkPath%" -> "%SourcePath%"
mklink /D "%LinkPath%" "%SourcePath%"
if errorlevel 1 (
    echo Error creating symlink!
) else (
    echo Symlink successfully created.
)

echo Finished.